
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/



var STBPluginAnimate = Object.create(STBModule.prototype);

STBPluginAnimate.name = "PluginAnimate";
STBPluginAnimate.initPlugin = function () {

	var animationType = ['fadeInLeftSmall' , 'fadeInRightSmall' , 'fadeInUpSmall' , 'fadeInDownSmall', 'infinite' , 'bounce', 'flash', 'pulse', 'rubberBand', 'shake', 'swing', 'tada', 'wobble', 'bounceIn', 'bounceInDown', 'bounceInLeft', 'bounceInRight', 'bounceInUp', 'bounceOut', 'bounceOutDown', 'bounceOutLeft', 'bounceOutRight', 'bounceOutUp', 'fadeIn', 'fadeInDown', 'fadeInDownBig', 'fadeInLeft', 'fadeInLeftBig', 'fadeInRight', 'fadeInRightBig', 'fadeInUp', 'fadeInUpBig', 'fadeOut', 'fadeOutDown', 'fadeOutDownBig', 'fadeOutLeft', 'fadeOutLeftBig', 'fadeOutRight', 'fadeOutRightBig', 'fadeOutUp', 'fadeOutUpBig', 'flipInX', 'flipInY', 'flipOutX', 'flipOutY', 'lightSpeedIn', 'lightSpeedOut', 'rotateIn', 'rotateInDownLeft', 'rotateInDownRight', 'rotateInUpLeft', 'rotateInUpRight', 'rotateOut', 'rotateOutDownLeft', 'rotateOutDownRight', 'rotateOutUpLeft', 'rotateOutUpRight', 'hinge', 'rollIn', 'rollOut', 'zoomIn', 'zoomInDown', 'zoomInLeft', 'zoomInRight', 'zoomInUp', 'zoomOut', 'zoomOutDown', 'zoomOutLeft', 'zoomOutRight', 'zoomOutUp', 'slideInDown', 'slideInLeft', 'slideInRight', 'slideInUp', 'slideOutDown', 'slideOutLeft', 'slideOutRight', 'slideOutUp'],
		lnt = animationType.length,
		hasPreloader = STBGlobalPreloader.isVisible();


	if ($(".animated:not([data-animate])").length > 0) {


		for (var i = 0; i < lnt; i++) {
			var obj = $("." + animationType[i] + ":not([data-animate])");

			if (obj.length > 0) {

				obj.each(function() {

					var element = $(this);

					if (!STBUtils.isInView($(this)) || hasPreloader) {
						$(this).attr("data-animate", "animated").removeClass("animated");

						var dataValue = element.attr("data-animate");

						element.attr("data-animate", dataValue + ' ' + animationType[i]).removeClass(animationType[i]).addClass("to-animate");
					} else {
						$(this).attr("data-animate" , "__");
					}

				});
			}

		}


	}

	//add animation for titles
	$(".widget-head:not(.__done_animate), .module-head:not(.__done_animate)").addClass("to-animate").attr("data-animate", "animated-title");

	var dataAnimate = $('[data-animate]:not(.__done_animate)');

	if (dataAnimate.length > 0) {

//		var ScrollMagicGlobalController = new ScrollMagic.Controller();


		dataAnimate.each(function() {
			var element = $(this);

			element.bind('inview', function (event, isInView) {
				if (isInView) {
					if (!STBGlobalPreloader.isVisible())	{
						element.addClass(element.attr("data-animate")).removeClass("to-animate").unbind('inview');
					}
				}
			});


			/*
					scene = new ScrollMagic.Scene({                        
						triggerElement: this,
						triggerHook: 0.7,
						reverse: false
					})
					.on("start leave", function(event) {

						if (!STBGlobalPreloader.isVisible())	{
							console.log("ok");
							el.addClass(el.attr("data-animate")).removeClass("to-animate");
						} else {
							console.log("xx");
						}
						
					})
					.addTo(ScrollMagicGlobalController);

				el.addClass("__done_animate");
			});
			*/
		});
	}
}

STBPluginAnimate.animateVisible = function() {
	var elements = $(".to-animate");

	if (elements.length > 0){
		elements.each(function() {
			var el = $(this);

			if (STBUtils.isInView(el)) {
				el.addClass(el.attr("data-animate")).removeClass("to-animate");
			}
		});
	}
}

STBPluginAnimate.runOnLoad = function() {

	STBPluginAnimate.initPlugin();
}

STBPluginAnimate.runOnContentUpdate = function() {
	STBPluginAnimate.initPlugin();
}

STBPluginAnimate.runAfterLoad = function() {

	if (!STBGlobalPreloader.isActive()){
		return null;
	}

	setTimeout(
		function() {
			STBPluginAnimate.animateVisible();
		},
		STBGlobalPreloader.fadeDuration
	);
}



site.registerModule(STBPluginAnimate);